/****************************************************************************
* Copyright (C) 2008 Airtight Interactive. All Rights Reserved.
* Usage of this code is subject to the Terms of Use accompanying
* this product.
****************************************************************************/

import com.airtightinteractive.apps.viewers.postcardviewer.XMLManager;
import com.airtightinteractive.apps.viewers.postcardviewer.TweenExtended;
import com.airtightinteractive.apps.viewers.postcardviewer.Options;
import com.airtightinteractive.apps.viewers.postcardviewer.ViewArea;
import com.airtightinteractive.apps.viewers.postcardviewer.Main;
import mx.transitions.easing.Strong;
import mx.utils.Delegate;
import mx.transitions.Tween;

/**
 * Image Class. Creates and loads an image. On image loaded creates frame and centers.
 */
class com.airtightinteractive.apps.viewers.postcardviewer.Image{
	
	private static var PILE_DIM:Number = 300;
	
	private var mIndex:Number;
	private var mURL:String;
	private var mX:Number;
	private var mY:Number;
	private var mClip_mc:MovieClip;	
	private var mCaption_mc:MovieClip;	
	private var mLoader_mc:MovieClip;
	private var mLoader_mcl:MovieClipLoader;
	private var mExpandTween:TweenExtended;
	
	public function Image(target, index, url,caption,x,y){
									
		mIndex = index;
		mURL = url;
		mX = x;
		mY = y;		
		
		//create image base clip
		var d = target.getNextHighestDepth();
		mClip_mc = target.attachMovie("sFrame","mcImg"+d,d);							
		mClip_mc._rotation = Math.random()* Options.maxRotation - Options.maxRotation/2;			
		var col:Color = new Color(mClip_mc.mcFrame);
		col.setRGB(XMLManager.getInstance().frameColor);
		
		//load jpg
		mLoader_mc = mClip_mc.createEmptyMovieClip("mcLoader",mClip_mc.getNextHighestDepth());			
		mLoader_mcl = new MovieClipLoader();
		mLoader_mcl.addListener(this);
		mLoader_mcl.loadClip(url,mLoader_mc);
				
		//add caption
		if (caption == "undefined" || caption == undefined){
			caption = "";
		}		
		mCaption_mc  = mClip_mc.attachMovie("sCaption","mcCaption",mClip_mc.getNextHighestDepth());			
		mCaption_mc.txtCaption.html = true;
		mCaption_mc.txtCaption.wordWrap = true;
		mCaption_mc.txtCaption.multiline = true;
		mCaption_mc.txtCaption.autosize = true;	
		mCaption_mc.txtCaption.embedFonts = true;
		mCaption_mc.txtCaption.htmlText = "<font color=\"#" + ARGBHexToString(XMLManager.getInstance().captionColor) + "\">" + caption + "</font>";
		
		mCaption_mc._visible = false;
		
		//hide until loaded
		mClip_mc._visible = false;			
	}
		
	private function onLoadInit(){
		
		mLoader_mc.forceSmoothing = Options.useSmoothing;
		//center jpg
		mLoader_mc._x = -mLoader_mc._width/2;
		mLoader_mc._y = -mLoader_mc._height/2;			
		//position frame
		mClip_mc.mcFrame._width = mLoader_mc._width + XMLManager.getInstance().frameWidth*2;
		mClip_mc.mcFrame._height = mLoader_mc._height + XMLManager.getInstance().frameWidth*2;
		mClip_mc.mcFrame._x = -mClip_mc.mcFrame._width/2;
		mClip_mc.mcFrame._y = -mClip_mc.mcFrame._height/2;	
		
		//position caption
		mCaption_mc.txtCaption._width = mLoader_mc._width - 2*Options.captionPadding;
		mCaption_mc.txtCaption._height = Math.min(mCaption_mc.txtCaption.textHeight+ Options.captionPadding,mLoader_mc._height - Options.captionPadding);		
		mCaption_mc._x = mLoader_mc._x + Options.captionPadding;
		mCaption_mc._y = mLoader_mc._y + mLoader_mc._height - mCaption_mc.txtCaption._height;
					
		mClip_mc._visible = true;
		
		//set click action
		mLoader_mc.onRelease = Delegate.create(this,onRelease);
		mClip_mc.mcFrame.onRelease = Delegate.create(this,onRelease);
		//mLoader_mc.useHandCursor = false;
		//mClip_mc.mcFrame.useHandCursor = false;
		
		//expand from a pile
		mExpandTween = new TweenExtended(mClip_mc,["_x","_y"],Strong.easeInOut,[Math.random()*PILE_DIM,Math.random()*PILE_DIM],[mX,mY],Options.zoomLength,false);		
		
		//set right click menu
		var cm:ContextMenu = new ContextMenu ();
		cm.hideBuiltInItems();
		if (XMLManager.getInstance().enableRightClickOpen){
			cm.customItems.push(new ContextMenuItem(Main.getInstance().mLangOpenImage + "...", Delegate.create(this,openImage)));		
		}		
		cm.customItems.push(Main.getInstance().getCMItem());			
		mClip_mc.menu = cm;					
	}
	
	private function onRelease(){
		ViewArea.getInstance().onImageClick(mIndex);
	}
	
	public function zoomIn(zoomin:Boolean){		
		mCaption_mc._visible = zoomin;
		//mClip_mc.onRelease = null;
	}
	
	/**
	 * Open current image in a new browser window
	 */
	private function openImage(){		
		getURL(mURL,"_blank");
	}	
	
	private function ARGBHexToString(p_hex:Number):String {	
		return (((p_hex>> 24) != 0) ? Number((p_hex>>> 24) & 0xFF).toString(16) : "")+Number(p_hex & 0xFFFFFF).toString(16);
	}
	
}