/****************************************************************************
* Copyright (C) 2008 Airtight Interactive. All Rights Reserved.
* Usage of this code is subject to the Terms of Use accompanying
* this product.
****************************************************************************/

import mx.utils.Delegate;
import com.airtightinteractive.apps.viewers.postcardviewer.*;

/**
 * Main application class for PostViewer. 
 * Handles stage layout, navigation.
 * For documentation on AutoViewer see: http://www.airtightinteractive.com/projects/postcardviewer/pro
 */
 
class com.airtightinteractive.apps.viewers.postcardviewer.Main {

	private static var instance : Main;
	private static var IS_PRO:Boolean = true;
	private static var VERSION:String = "1.2";
	private static var LINK_URL:String = "http://www.airtightinteractive.com/projects/postcardviewer/"; //URL used when download link is clicked	
	private static var RESIZE_TIME:Number = 50;
		
	private var mViewArea:ViewArea;
	private var mXMLManager : XMLManager;
	private var mClip_mc:MovieClip;
	private var mView_mc:MovieClip;	
	private var mBack_mc:MovieClip;	
	private var mLangAbout:String = "About";
	public var mLangOpenImage:String = "Open Image in New Window";		
	private var mLogo_mc:MovieClip;
	private var mInstruct_mc:MovieClip;
	private var mResize_int:Number;		
				
	/**
	 * @return singleton instance of Main
	 */
	public static function getInstance() : Main {
		if (instance == null)
			instance = new Main();
		return instance;
	}
	
	private function Main() {		
	}
	
	public function init(target:MovieClip){

		//initialize stage properties
		//_quality =  "BEST"; //defaults to high
		Stage.align = "TL"; 
		Stage.scaleMode = "noScale";
		stop();

		mClip_mc = target;
		
		mBack_mc = mClip_mc.attachMovie("sFrame","mcBack",mClip_mc.getNextHighestDepth());
		mBack_mc._alpha = 0;
		mBack_mc.useHandCursor = false;
		mBack_mc.onRelease = Delegate.create(this,onBkgndRelease);
		
		mView_mc = mClip_mc.createEmptyMovieClip("mcMain",mClip_mc.getNextHighestDepth());		
				
		//get localization language
		if (_root.langAbout != undefined){
			mLangAbout = _root.langAbout;
		}
		if (_root.langOpenImage != undefined){
			mLangOpenImage = _root.langOpenImage;
		}
		
		//set up resize			
		Stage.addListener(this);
		
		//create ViewArea
		mViewArea = ViewArea.getInstance();	
		mViewArea.init(mView_mc);
		mXMLManager = XMLManager.getInstance();									
		
		doLayout();
		
		mXMLManager.loadXML();	
				
	}
	
	public function onXMLLoaded(){	
		mViewArea.onXMLLoaded();
		
		//show instructions
		if (Options.showInstructions){
			mInstruct_mc = mClip_mc.attachMovie("sInstruct","mcLogo",mClip_mc.getNextHighestDepth());		
		}
		
		//init download logo
		if (!IS_PRO){
			mLogo_mc = mClip_mc.attachMovie("sLogo","mcLogo",mClip_mc.getNextHighestDepth());			
			mLogo_mc.onRelease = Delegate.create(this,onLogoClick);	
			mLogo_mc.useHandCursor = true;
		}
		
		doLayout();
		
		setRightClickMenu();
	}
		
	//call doLayout when the stage is resized	
	private function onResize(){				
		if (mResize_int == null){
			mResize_int = setInterval(Delegate.create(this,doLayout),RESIZE_TIME);
		}	
	}

	private function doLayout(){		
		clearInterval(mResize_int);
		mResize_int = null;
		
		var w:Number = Stage.width;
		var h:Number = Stage.height;;
		if (Options.pcvStageWidth != null) w = Options.pcvStageWidth;
		if (Options.pcvStageHeight != null) h = Options.pcvStageHeight;		
		
		//center viewarea
		mView_mc._x = w/2;
		mView_mc._y = h/2;
		
		//layout logo
		mLogo_mc._x = Math.round(w - mLogo_mc._width - 10);
		mLogo_mc._y = Math.round(h - mLogo_mc._height - 10);
		
		mInstruct_mc._x = 10;
		mInstruct_mc._y = Math.floor (h  - mInstruct_mc._height - 10);
		
		mViewArea.setStageSize(w,h);
		
		//bkgnd
		mBack_mc._x = w/2;
		mBack_mc._y = h/2;
		mBack_mc._width = w;
		mBack_mc._height = h;
		
	}		
	
	private function onLogoClick():Void{	
		getURL(LINK_URL,"_blank");
	};	
	
	/**
	* initialize right click menu		
	*/
	public function setRightClickMenu(){		
			
		var cm:ContextMenu = new ContextMenu ();
		cm.hideBuiltInItems();
		cm.customItems.push(getCMItem());
		mClip_mc.menu = cm;	
	}
	
	public function getCMItem():ContextMenuItem{	
		if (!IS_PRO){
			var cmi = new ContextMenuItem(mLangAbout + " PostcardViewer " + VERSION + "...", Delegate.create(this,onLogoClick));
			return cmi
		}else{
			return null;
		}		
	}
	
	private function onBkgndRelease(){
		mViewArea.zoomOut();
	}
	
	public function showError(msg:String){	
		var mCaption_mc  = mClip_mc.attachMovie("sCaption","mcCaption",mClip_mc.getNextHighestDepth());
		mCaption_mc.txtCaption.text = msg;
		mCaption_mc._x = Stage.width/2 - mCaption_mc.txtCaption.textWidth/2;
		mCaption_mc._y = Stage.height/2;
	}
		
 }
