/****************************************************************************
* Copyright (C) 2008 Airtight Interactive. All Rights Reserved.
* Usage of this code is subject to the Terms of Use accompanying
* this product.
****************************************************************************/

import com.airtightinteractive.apps.viewers.postcardviewer.XMLManager;
import com.airtightinteractive.apps.viewers.postcardviewer.TweenExtended;
import com.airtightinteractive.apps.viewers.postcardviewer.Options;
import com.airtightinteractive.apps.viewers.postcardviewer.Image;
import com.airtightinteractive.apps.viewers.postcardviewer.Main;
import mx.transitions.easing.Strong;

/**
 * Handles Image Navigation
 */

class com.airtightinteractive.apps.viewers.postcardviewer.ViewArea{
	
	private static var instance : ViewArea;
	
	private var mImages:Array;
	private var mClip_mc:MovieClip;
	private var mXMLManager : XMLManager;
	private var mViewTween:TweenExtended;	
	private var mCurrentIndex:Number;
	private var mZoomedIn:Boolean;	
	private var mGridWidth:Number;
	private var mGridHeight:Number;
	private var mZoomOutPerc:Number;
		
	/**
	 * @return singleton instance of ViewArea
	 */
	public static function getInstance() : ViewArea {
		if (instance == null)
			instance = new ViewArea();
		return instance;
	}
		
	private function ViewArea() {			
	}
	
	public function init(target){
				
		mClip_mc = target.createEmptyMovieClip("mcViewArea",target.getNextHighestDepth());
		mXMLManager = XMLManager.getInstance();	
		
		//init Keyboard nav	
		Key.addListener(this);	
		
		//zoomed out		
		mZoomedIn = false;
		mCurrentIndex = 0;
	}
	
	public function onXMLLoaded(){
		
		var imgDim = mXMLManager.cellDimension;		
		mGridWidth =  imgDim*mXMLManager.columns;
		mGridHeight = imgDim*mXMLManager.rows;
		mZoomOutPerc = mXMLManager.zoomOutPerc;	
		
		//layout images
		mImages = [];
		for (var i = 0;i<mXMLManager.mImageCount;i++){					
			mImages[i] = new Image(mClip_mc,i,mXMLManager.aImageURLs[i],
									mXMLManager.aImageCaptions[i],
									getImageX(i),getImageY(i));	
		}												  
		
		mViewTween = new TweenExtended(mClip_mc,["_x","_y","_xscale","_yscale"],Strong.easeOut,
												[0,0,mXMLManager.zoomOutPerc,mXMLManager.zoomOutPerc],
												[0,0,mXMLManager.zoomOutPerc,mXMLManager.zoomOutPerc],
												Options.zoomLength,false);
		mClip_mc._xscale = mXMLManager.zoomOutPerc;
		mClip_mc._yscale = mXMLManager.zoomOutPerc;	
				
	}
	
	public function onImageClick(index:Number){		
		if (index == mCurrentIndex && mZoomedIn){
			zoomOut();			
		}else{
			zoomTo(index);			
		}				
	}
	
	private function zoomTo(index){
		if (index < 0 || index >= mXMLManager.mImageCount) return;			
		mViewTween.continueTo([-getImageX(index)*mXMLManager.zoomInPerc/100,-getImageY(index)*mXMLManager.zoomInPerc/100,mXMLManager.zoomInPerc,mXMLManager.zoomInPerc],Options.zoomLength);					
		mImages[mCurrentIndex].zoomIn(false);
		mCurrentIndex = index;		
		mImages[mCurrentIndex].zoomIn(true)
		mZoomedIn = true;				
	}
	
	public function zoomOut(){	
		mViewTween.continueTo([0,0,mZoomOutPerc,mZoomOutPerc],Options.zoomLength);		
		mImages[mCurrentIndex].zoomIn(false);
		mZoomedIn = false;		
	}
	
	private function getImageX(index:Number):Number{
		return mXMLManager.cellDimension*(index%mXMLManager.columns) + mXMLManager.cellDimension/2	- mGridWidth/2;	
	}
	
	private function getImageY(index:Number):Number{
		return mXMLManager.cellDimension*Math.floor(index/mXMLManager.columns) + mXMLManager.cellDimension/2 - mGridHeight/2;
	}
	
	private function toggleZoom(){
		if (mZoomedIn){
			zoomOut();
		}else{
			zoomTo(mCurrentIndex);
		}
	}
	
	private function onKeyDown() {			
		if(Key.isDown(Key.LEFT)) {					
			zoomTo(mCurrentIndex -1);					
		}else if(Key.isDown(Key.RIGHT)){
			zoomTo(mCurrentIndex +1);					
		}else if(Key.isDown(Key.UP)){				
			zoomTo(mCurrentIndex - mXMLManager.columns);			
		}else if(Key.isDown(Key.DOWN)){
			zoomTo(mCurrentIndex + mXMLManager.columns);						
		}else if(Key.isDown(Key.SPACE)){
			toggleZoom();			
		}			
	}	
	
	public function get currentIndex():Number{
		return mCurrentIndex;
	}
	
	public function setStageSize(w:Number, h:Number){
		if (Options.zoomOutToFit){
			mZoomOutPerc = Math.min(100 * w/mGridWidth,100 * h/mGridHeight);
			if (!mZoomedIn) zoomOut();
		}
	}
}