/****************************************************************************
* Copyright (C) 2008 Airtight Interactive. All Rights Reserved.
* Usage of this code is subject to the Terms of Use accompanying
* this product.
****************************************************************************/

import mx.utils.Delegate;

import com.airtightinteractive.apps.viewers.postcardviewer.Main;
import com.airtightinteractive.apps.viewers.postcardviewer.Options;

/**
 * Handles xml loading,parsing
 */
class com.airtightinteractive.apps.viewers.postcardviewer.XMLManager {
	
	private static var instance : XMLManager;	
	
	//Results data
	private var xmlResults:XML;	
	public var mImageCount:Number =0;  
	public var aImageURLs:Array;
	public var aImageCaptions:Array;
	
	public var cellDimension:Number = 800;	
	public var columns:Number = 5;	
	public var rows:Number = 5;	
	public var zoomOutPerc:Number = 15;	
	public var zoomInPerc:Number = 100;	
	public var frameWidth:Number = 20;
	public var frameColor:Number = 0xFFFFFF;
	public var captionColor:Number = 0xFFFFFF; 
	public var enableRightClickOpen:Boolean = false;
		
	/**
	 * @return singleton instance of XMLManager
	 */
	public static function getInstance() : XMLManager {
		if (instance == null)
			instance = new XMLManager();
		return instance;
	}
		
	private function XMLManager() {	
		xmlResults = new XML();	
		xmlResults.ignoreWhite = true;		
		xmlResults.onLoad = Delegate.create(this, onXMLLoaded);		
	}
 	
	public function loadXML():Void{	
				
		var xmlURL:String = "gallery.xml";
		//get xml url from flash vars
		if (_root.xmlURL != undefined){
			xmlURL = _root.xmlURL;
		}
		if (Options.xmlURL != null){
			xmlURL = Options.xmlURL;
		}
		xmlResults.load(xmlURL);				
	}	
	
	private function onXMLLoaded(success:Boolean):Void{
						
		aImageURLs = [];
		aImageCaptions = [];
		
		if (!success) Main.getInstance().showError("Gallery XML not found");	
		
		var xmlRoot = xmlResults.firstChild;
		
		//get gallery attributes
		var val:Number;			
		val = Number(xmlRoot.attributes.frameColor);			
		if (isValidNumber(val)) frameColor = val;
					
		val = Number(xmlRoot.attributes.frameWidth);
		if (isValidNumber(val)) frameWidth = val;
		
		val = Number(xmlRoot.attributes.cellDimension);
		if (isValidNumber(val)) cellDimension = val;
		
		val = Number(xmlRoot.attributes.columns);
		if (isValidNumber(val)) columns = val;
		
		val = Number(xmlRoot.attributes.zoomOutPerc);
		if (isValidNumber(val)) zoomOutPerc = val;
		
		val = Number(xmlRoot.attributes.zoomInPerc);
		if (isValidNumber(val)) zoomInPerc = val;
		
		val = Number(xmlRoot.attributes.captionColor);			
		if (isValidNumber(val)) captionColor = val;			
								
		enableRightClickOpen = getBoolean(xmlRoot.attributes.enableRightClickOpen,enableRightClickOpen);		
																	
		mImageCount = xmlRoot.childNodes.length;
		
		if (mImageCount < 1) Main.getInstance().showError("No image nodes found in gallery XML");			
			
		for (var i:Number = 0;i<mImageCount;i++){											
			var resultNode:XMLNode = xmlRoot.childNodes[i];	
			aImageURLs.push(resultNode.childNodes[0].firstChild.nodeValue);					
			aImageCaptions.push(resultNode.childNodes[1].firstChild.nodeValue);				
		}	
		
		//calc rows
		rows = Math.floor(mImageCount/columns);				
		if (mImageCount%columns != 0) rows++;
		
		//randomize image order
		if (Options.randomize){
			var len = aImageURLs.length;
			for (var i = 0; i<len; i++) {
				var rand = Math.floor(Math.random()*len);
				
				var temp = aImageURLs[i];
				aImageURLs[i] = aImageURLs[rand];
				aImageURLs[rand] = temp;
				
				var temp2 = aImageCaptions[i];
				aImageCaptions[i] = aImageCaptions[rand];
				aImageCaptions[rand] = temp2;
			}
		}
		
		//render results
		Main.getInstance().onXMLLoaded();
					
	}
	
	function isValidNumber(x:Number){		
		return !(isNaN(x) || x == undefined);		
	}
	
	function getBoolean(s:String,def:Boolean):Boolean{		
		if (s.toLowerCase() == "true") return true;
		if (s.toLowerCase() == "false") return false;
		return def;
	}	
}